﻿
/****************************************************************************/
/*Copyright (c) 2011, Florent DEVILLE.                                      */
/*All rights reserved.                                                      */
/*                                                                          */
/*Redistribution and use in source and binary forms, with or without        */
/*modification, are permitted provided that the following conditions        */
/*are met:                                                                  */
/*                                                                          */
/* - Redistributions of source code must retain the above copyright         */
/*notice, this list of conditions and the following disclaimer.             */
/* - Redistributions in binary form must reproduce the above                */
/*copyright notice, this list of conditions and the following               */
/*disclaimer in the documentation and/or other materials provided           */
/*with the distribution.                                                    */
/* - The names of its contributors cannot be used to endorse or promote     */
/*products derived from this software without specific prior written        */
/*permission.                                                               */
/* - The source code cannot be used for commercial purposes without         */
/*its contributors' permission.                                             */
/*                                                                          */
/*THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS       */
/*"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT         */
/*LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS         */
/*FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE            */
/*COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,       */
/*INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,      */
/*BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;          */
/*LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER          */
/*CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT        */
/*LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN         */
/*ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE           */
/*POSSIBILITY OF SUCH DAMAGE.                                               */
/****************************************************************************/

using System;

namespace GE.TimeClock
{
    class Clock
    {
        /// <summary>
        /// singleton
        /// </summary>
        static Clock m_instance = new Clock();

        /// <summary>
        /// Represent the time when the Clock was initialised.
        /// </summary>
        DateTime m_startTime;

        /// <summary>
        /// the time when stopClock was called
        /// </summary>
        DateTime m_dateOffsetTime;

        int m_offsetTime;

        /// <summary>
        /// 
        /// </summary>
        public static Clock instance
        {
            get
            {
                return m_instance;
            }
        }

        public Clock()
        {
            m_startTime = DateTime.Now;
            m_dateOffsetTime = DateTime.Now;
            m_offsetTime = 0;
        }

        public bool init() { return true; }

        public int millisecs
        {
            get
            {
                return (int)DateTime.Now.Subtract(m_startTime).TotalMilliseconds - m_offsetTime;
            }
        }

        public void stopClock()
        {
            m_dateOffsetTime = DateTime.Now;
        }

        /// <summary>
        /// To call only if stopClock was called before
        /// </summary>
        public void startClock()
        {
            m_offsetTime += (int)DateTime.Now.Subtract(m_dateOffsetTime).TotalMilliseconds;
        }




            
    }
}
